package gov.va.genisis2.converter;

import org.springframework.stereotype.Component;

import gov.va.genisis2.common.enums.RefreshStatusEnum;
import gov.va.genisis2.model.RefreshHistory;
import gov.va.genisis2.util.DateUtil;

/**
 * This class is used to convert RefreshHistoryDTO to UserRefreshHistory entity
 * and vice-versa.
 * 
 * @author PII
 *
 */
@Component
public class RefreshHistoryConverter {

	public RefreshHistory populateUserRefreshHistory(String username, String jobType) {
		RefreshHistory refreshHistory = new RefreshHistory();

		refreshHistory.setScheduledBy(username);
		refreshHistory.setStartDate(DateUtil.getTodaysDate());
		refreshHistory.setStatus(RefreshStatusEnum.STARTED.getDesc());
		refreshHistory.setJobType(jobType);
		return refreshHistory;
	}

	public RefreshHistory populateUserRefreshHistory(RefreshHistory refreshHistory) {
		refreshHistory.setEndDate(DateUtil.getTodaysDate());
		refreshHistory.setStatus(RefreshStatusEnum.COMPLETED.getDesc());

		return refreshHistory;
	}

	public RefreshHistory populateUserRefreshHistory(RefreshHistory refreshHistory, String errorMessage) {
		refreshHistory.setStatus(RefreshStatusEnum.FAILED.getDesc());
		refreshHistory.setErrorMessage(errorMessage);

		return refreshHistory;
	}

	public RefreshHistory populateStudyApprovalRefreshHistory(String username) {
		RefreshHistory refreshHistory = new RefreshHistory();

		refreshHistory.setScheduledBy(username);
		refreshHistory.setStartDate(DateUtil.getTodaysDate());
		refreshHistory.setStatus(RefreshStatusEnum.STARTED.getDesc());
		refreshHistory.setJobType("StudyApproval");
		return refreshHistory;
	}

	public RefreshHistory populateStudyApprovalRefreshHistory(RefreshHistory refreshHistory) {
		refreshHistory.setEndDate(DateUtil.getTodaysDate());
		refreshHistory.setStatus(RefreshStatusEnum.COMPLETED.getDesc());

		return refreshHistory;
	}

	public RefreshHistory populateStudyApprovalRefreshHistory(RefreshHistory refreshHistory, String errorMessage) {
		refreshHistory.setStatus(RefreshStatusEnum.FAILED.getDesc());
		refreshHistory.setErrorMessage(errorMessage);

		return refreshHistory;
	}
}
